/*"File Comment""***************************************************************
 *
 *   Copyright (c) 2011 
 *   All Rights Reserved
 *
 *******************************************************************************
 *  Project Name : CANBootloader_USB2CAN
 *  File Name    : mcu.c
 *  Content      : MCU initialization
 *  CPU          : MCF51JM128
 *  Compiler     : CodeWarrior for coldfire 10.1
 *  OS           :                                
 *  UPDATED HISTORY:
 *  REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
 *  ---   ----------  ------        --------------------- 
 *  0.1   2011.09.09  Tiko          Created
 *
 *""File Comment End""*********************************************************/
/*--------------------Files Included------------------------------------------*/
#include "config.h"
#include "mcu.h"
#include "uart.h"
/*---------------------static Function prototype------------------------------*/
static void SystemClockInit(void);
static void GPIO_Init(void);
static void SCI_Init(void);
static void RTC_Init(void);
static void TPM1_Init(void);
static void TPM2_Init(void);
/*---------------------Functions Below----------------------------------------*/
/*""FUNC COMMENT""*************************************************************
 *  Function   :  MCU_Init
 *  Name       :
 * *----------------------------------------------------------------------------
 * Function    :  Initialize the MCU
 * Description :
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :   None
 *------------------------------------------------------------------------------
 * Input       :   None
 * Output      :
 *------------------------------------------------------------------------------
 * Functions used :SystemClockInit();GPIO_Init();
 *------------------------------------------------------------------------------
 * Notice      :
 *------------------------------------------------------------------------------
 * History     : 2011.09.09 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
void MCU_Init()
{
    DisableInterrupts;
    /* Common initialization of the write once registers */
    /* SOPT1: COPT=0,STOPE=0,WAITE=1 */
    SOPT1 = 0x10U;
    /* SOPT2: COPCLKS=0,COPW=0,USB_BIGEND=1,CLKOUT_EN=0,CMT_CLK_SEL=0,SPI1FE=1,SPI2FE=1,ACIC=0 */
    SOPT2 = 0x00U;
    /* SPMSC1: LVWF=0,LVWACK=0,LVWIE=0,LVDRE=1,LVDSE=1,LVDE=0,BGBE=0 */
    SPMSC1 = 0x18U;
    /* SPMSC2: LVDV=0,LVWV=0,PPDF=0,PPDACK=0,PPDC=0 */
    SPMSC2 = 0x00U;
    /* Initialization of CPU registers */
    /*lint -save  -e950 Disable MISRA rule (1.1) checking. */
    asm
    {
        /* VBR: ADDRESS=0 */
        clr.l d0
        movec d0,VBR
        /* CPUCR: ARD=0,IRD=0,IAE=0,IME=0,BWD=0,FSD=0 */
        clr.l d0
        movec d0,CPUCR
    }
    /*lint -restore Enable MISRA rule (1.1) checking. */
    /* SCGC1: CMT=1,TPM2=1,TPM1=1,ADC=0,IIC2=0,IIC1=0,SCI2=0,SCI1=0 */
    SCGC1 = 0xFFU;
    /* SCGC2: USB=1,FLS=1,IRQ=1,KBI=1,ACMP=0,RTC=1,SPI2=0,SPI1=0 */
    SCGC2 = 0xFFU;
    /* SCGC3: RNGA=0 */
    SCGC3 = 0xFFU;
    GPIO_Init();
    SystemClockInit();
    RTC_Init();
    /* Common initialization of the CPU registers */
    /* ### */
    /*lint -save  -e950 Disable MISRA rule (1.1) checking. */
    asm
    { /* Set Interrupt level 0 */
        move.w SR,D0;
        andi.l #0xF8FF,D0;
        move.w D0,SR;
    };
}

/*""FUNC COMMENT""**************************************************************
 *  Function   :  SystemClockInit
 *  Name       :
 * *----------------------------------------------------------------------------
 * Function    : Initialize system Clock: external 12MHz. PEE mode,
 * Description :  Bus Clock = 24MHz
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :   None
 *------------------------------------------------------------------------------
 * Input       :   None
 * Output      :
 *------------------------------------------------------------------------------
 * Functions used :  None
 *------------------------------------------------------------------------------
 * Notice      :
 *------------------------------------------------------------------------------
 * History     : 2011.09.09 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
static void SystemClockInit()
{

    /*lint -save  -e923 Disable MISRA rule (11.3) checking. */
    if (*(unsigned char*far)0x03FFU != 0xFFU)
    { /* Test if the device trim value is stored on the specified address */
        MCGTRM = *(unsigned char*far)0x03FFU; /* Initialize MCGTRM register from a non volatile memory */
        MCGSC = *(unsigned char*far)0x03FEU; /* Initialize MCGSC register from a non volatile memory */
    }
    /*lint -restore Enable MISRA rule (11.3) checking. */
    /* MCGC2: BDIV=0,RANGE=1,HGO=1,LP=0,EREFS=1,ERCLKEN=1,EREFSTEN=0 */
    MCGC2 = 0x36U; /* Set MCGC2 register */
    while(MCGSC_OSCINIT == 0U)
    { /* Wait until external reference is stable */
    }
    /* MCGC3: DIV32=1 */
    MCGC3 |= (unsigned char)0x10U;
    /* MCGC1: CLKS=2,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
    MCGC1 = 0x98U; /* Set MCGC1 register */
    while(MCGSC_IREFST != 0U)
    { /* Wait until external reference is selected */
    }
    /* MCGC3: LOLIE=0,PLLS=0,CME=0,DIV32=1,VDIV=8 */
    MCGC3 = 0x18U; /* Set MCGC3 register */
    /* MCGC4: DMX32=0,DRST_DRS=0 */
    MCGC4 = 0x00U; /* Set MCGC4 register */
    while((MCGSC & 0x0CU) != 0x08U)
    { /* Wait until external clock is selected as a bus clock reference */
    }
    /* MCGC2: BDIV=0,RANGE=1,HGO=1,LP=1,EREFS=1,ERCLKEN=1,EREFSTEN=0 */
    MCGC2 = 0x3EU; /* Set MCGC2 register */
    /* MCGC1: CLKS=2,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
    MCGC1 = 0x98U; /* Set MCGC1 register */
    /* MCGC3: LOLIE=0,PLLS=0,CME=0,DIV32=0,VDIV=8 */
    MCGC3 = 0x08U; /* Set MCGC3 register */
    /* MCGC3: LOLIE=0,PLLS=1,CME=0,DIV32=0,VDIV=8 */
    MCGC3 = 0x48U; /* Set MCGC3 register */
    while(MCGSC_PLLST == 0U)
    { /* Wait until PLL is selected */
    }
    /* MCGC2: LP=0 */
    MCGC2 &= (unsigned char)~(unsigned char)0x08U;
    while(MCGSC_LOCK == 0U)
    { /* Wait until PLL is locked */
    }
    /* MCGC1: CLKS=0,RDIV=3,IREFS=0,IRCLKEN=0,IREFSTEN=0 */
    MCGC1 = 0x18U; /* Set MCGC1 register */
    while((MCGSC & 0x0CU) != 0x0CU)
    { /* Wait until PLL clock is selected as a bus clock reference */
    }
}

/*""FUNC COMMENT""**************************************************************
 *  Function   :   GPIO_Init
 *  Name       :
 * *------------------------------------------------------------------------------
 * Function    :  Initialize GPIO
 * Description :
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :  None
 *------------------------------------------------------------------------------
 * Input       :  None
 * Output      :
 *------------------------------------------------------------------------------
 * Functions used :  None
 *------------------------------------------------------------------------------
 * Notice      :   should be called as early as possible
 *------------------------------------------------------------------------------
 * History     : 2011.09.09 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
static void GPIO_Init()
{
    /* PTASE: PTASE7=1,PTASE6=1,PTASE5=1,PTASE4=1,PTASE3=1,PTASE2=1,PTASE1=1,PTASE0=1 */
    PTASE = 0xFFU;
    /* PTBSE: PTBSE7=1,PTBSE6=1,PTBSE5=1,PTBSE4=1,PTBSE3=1,PTBSE2=1,PTBSE1=1,PTBSE0=1 */
    PTBSE = 0xFFU;
    /* PTCSE: PTCSE7=1,PTCSE6=1,PTCSE5=1,PTCSE4=1,PTCSE3=1,PTCSE2=1,PTCSE1=1,PTCSE0=1 */
    PTCSE = 0xFFU;
    /* PTDSE: PTDSE7=1,PTDSE6=1,PTDSE5=1,PTDSE4=1,PTDSE3=1,PTDSE2=1,PTDSE1=1,PTDSE0=1 */
    PTDSE = 0xFFU;
    /* PTESE: PTESE7=1,PTESE6=1,PTESE5=1,PTESE4=1,PTESE3=1,PTESE2=1,PTESE1=1,PTESE0=1 */
    PTESE = 0xFFU;
    /* PTFSE: PTFSE7=1,PTFSE6=1,PTFSE5=1,PTFSE4=1,PTFSE3=1,PTFSE2=1,PTFSE1=1,PTFSE0=1 */
    PTFSE = 0xFFU;
    /* PTGSE: PTGSE7=1,PTGSE6=1,PTGSE5=1,PTGSE4=1,PTGSE3=1,PTGSE2=1,PTGSE1=1,PTGSE0=1 */
    PTGSE = 0xFFU;
    /* PTHSE: PTHSE4=1,PTHSE3=1,PTHSE2=1,PTHSE1=1,PTHSE0=1 */
    PTHSE |= (unsigned char) 0x1FU;
    /* PTJSE: PTJSE4=1,PTJSE3=1,PTJSE2=1,PTJSE1=1,PTJSE0=1 */
    PTJSE |= (unsigned char) 0x1FU;
    /* PTADS: PTADS7=0,PTADS6=0,PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
    PTADS = 0x00U;
    /* PTBDS: PTBDS7=0,PTBDS6=0,PTBDS5=0,PTBDS4=0,PTBDS3=0,PTBDS2=0,PTBDS1=0,PTBDS0=0 */
    PTBDS = 0x00U;
    /* PTCDS: PTCDS7=0,PTCDS6=0,PTCDS5=0,PTCDS4=0,PTCDS3=0,PTCDS2=0,PTCDS1=0,PTCDS0=0 */
    PTCDS = 0x00U;
    /* PTDDS: PTDDS7=0,PTDDS6=0,PTDDS5=0,PTDDS4=0,PTDDS3=0,PTDDS2=0,PTDDS1=0,PTDDS0=0 */
    PTDDS = 0x00U;
    /* PTEDS: PTEDS7=0,PTEDS6=0,PTEDS5=0,PTEDS4=0,PTEDS3=0,PTEDS2=0,PTEDS1=0,PTEDS0=0 */
    PTEDS = 0x00U;
    /* PTFDS: PTFDS7=0,PTFDS6=0,PTFDS5=0,PTFDS4=0,PTFDS3=0,PTFDS2=0,PTFDS1=0,PTFDS0=0 */
    PTFDS = 0x00U;
    /* PTGDS: PTGDS7=0,PTGDS6=0,PTGDS5=0,PTGDS4=0,PTGDS3=0,PTGDS2=0,PTGDS1=0,PTGDS0=0 */
    PTGDS = 0x00U;
    /* PTHDS: PTHDS4=0,PTHDS3=0,PTHDS2=0,PTHDS1=0,PTHDS0=0 */
    PTHDS = 0x00U;
    /* PTJDS: PTJDS4=0,PTJDS3=0,PTJDS2=0,PTJDS1=0,PTJDS0=0 */
    PTJDS = 0x00U;
    /* PTAIFE: PTAIFE7=1,PTAIFE6=1,PTAIFE5=1,PTAIFE4=1,PTAIFE3=1,PTAIFE2=1,PTAIFE1=1,PTAIFE0=1 */
    PTAIFE = 0xFFU;
    /* PTBIFE: PTBIFE7=1,PTBIFE6=1,PTBIFE5=1,PTBIFE4=1,PTBIFE3=1,PTBIFE2=1,PTBIFE1=1,PTBIFE0=1 */
    PTBIFE = 0xFFU;
    /* PTCIFE: PTCIFE7=1,PTCIFE6=1,PTCIFE5=1,PTCIFE4=1,PTCIFE3=1,PTCIFE2=1,PTCIFE1=1,PTCIFE0=1 */
    PTCIFE = 0xFFU;
    /* PTDIFE: PTDIFE7=1,PTDIFE6=1,PTDIFE5=1,PTDIFE4=1,PTDIFE3=1,PTDIFE2=1,PTDIFE1=1,PTDIFE0=1 */
    PTDIFE = 0xFFU;
    /* PTEIFE: PTEIFE7=1,PTEIFE6=1,PTEIFE5=1,PTEIFE4=1,PTEIFE3=1,PTEIFE2=1,PTEIFE1=1,PTEIFE0=1 */
    PTEIFE = 0xFFU;
    /* PTFIFE: PTFIFE7=1,PTFIFE6=1,PTFIFE5=1,PTFIFE4=1,PTFIFE3=1,PTFIFE2=1,PTFIFE1=1,PTFIFE0=1 */
    PTFIFE = 0xFFU;
    /* PTGIFE: PTGIFE7=1,PTGIFE6=1,PTGIFE5=1,PTGIFE4=1,PTGIFE3=1,PTGIFE2=1,PTGIFE1=1,PTGIFE0=1 */
    PTGIFE = 0x00U;
    /* PTHIFE: PTHIFE4=1,PTHIFE3=1,PTHIFE2=1,PTHIFE1=1,PTHIFE0=1 */
    PTHIFE |= (unsigned char) 0x1FU;
    /* PTJIFE: PTJIFE4=1,PTJIFE3=1,PTJIFE2=1,PTJIFE1=1,PTJIFE0=1 */
    PTJIFE |= (unsigned char) 0x1FU;

    PTDPE_PTDPE5 = 1U;
    PTDDD_PTDDD5 = 0U; /* input port*/

}

/*""FUNC COMMENT""*********************************************************
 *  Function   :   SCI_Init
 *  Name       :
 * *------------------------------------------------------------------------------
 * Function    :   Initialize SCI
 * Description :
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :   None
 *------------------------------------------------------------------------------
 * Input       :   None
 * Output      :   None
 *------------------------------------------------------------------------------
 * Functions used : None
 *------------------------------------------------------------------------------
 * Notice      :  None
 *------------------------------------------------------------------------------
 * History     : 2011.09.02 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
static void SCI_Init()
{
    ;
}

/*""FUNC COMMENT""*********************************************************
 *  Function   :   TPM1_Init
 *  Name       :
 * *------------------------------------------------------------------------------
 * Function    :   Initialize TPM1
 * Description :
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :   None
 *------------------------------------------------------------------------------
 * Input       :   None
 * Output      :   None
 *------------------------------------------------------------------------------
 * Functions used :  None
 *------------------------------------------------------------------------------
 * Notice      : None
 *------------------------------------------------------------------------------
 * History     : 2011.09.03 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
static void TPM1_Init()
{
    TPM1SC = 0x00U; /* prescaler factor is 7,divided-by 128 */
    TPM1MOD = 0x00U;
    TPM1C0SC = 0x00U;
    TPM1C1SC = 0x00U;
    TPM1C2SC = 0x00U;
    TPM1C3SC = 0x00U;
    TPM1C4SC = 0x00U;
    TPM1C5SC = 0x00U;

}
/*""FUNC COMMENT""*********************************************************
 *  Function   :   TPM2_Init
 *  Name       :
 * *------------------------------------------------------------------------------
 * Function    :   Initialize TPM2
 * Description :
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :   None
 *------------------------------------------------------------------------------
 * Input       :   None
 * Output      :
 *------------------------------------------------------------------------------
 * Functions used :  None
 *------------------------------------------------------------------------------
 * Notice      :  None
 *------------------------------------------------------------------------------
 * History     : 2011.09.02 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
static void TPM2_Init(void)
{
    TPM2SC = 0x47U; /* enable overflow interrupt,
     * prescaler factor is 7,divided-by 128 */
    TPM2MOD = 100000UL / ((128UL * 1000000UL / MCU_BUS_CLOCK)); /* 100ms overflow */
    TPM2C0SC = 0x00U;
    TPM2C1SC = 0x00U;
}

/*""FUNC COMMENT""*********************************************************
 *  Function   :   RTC_init
 *  Name       :
 * *------------------------------------------------------------------------------
 * Function    :   Initialize RTC, 1 s interrupt
 * Description :
 *------------------------------------------------------------------------------
 * Argument    :   None
 *             :
 *------------------------------------------------------------------------------
 * Return      :   None
 *------------------------------------------------------------------------------
 * Input       :   None
 * Output      :
 *------------------------------------------------------------------------------
 * Functions used :  None
 *------------------------------------------------------------------------------
 * Notice      :     None
 *------------------------------------------------------------------------------
 * History     : 2011.09.03 First version.
 *             :
 *""FUNC COMMENT END""*********************************************************/
static void RTC_Init()
{
    /*Clear interrupt flag; enable interrupt;Clock source: internal 1 KHz(LPO) */
    RTCSC = 0x80U;
    RTCMOD = 10U; /* will use 1000 as prescaler, then 5s interrupt */
}

